using System;

namespace gov.va.med.vbecs.DAL.VistALink.Client
{
	/// <summary>
	/// Connection state change event arguments used for 
	/// connection state change notification event.
	/// </summary>
	public class VistALinkConnectionStateChangedEventArgs : EventArgs
	{
		private bool _isAvailable;

		/// <summary>
		/// The only constructor.
		/// </summary>
		/// <param name="isAvailable">Parameter indicating whether VistALink is available or not.</param>
		public VistALinkConnectionStateChangedEventArgs( bool isAvailable )
		{
			_isAvailable = isAvailable;
		}

		/// <summary>
		/// Indicates whether VistALink is available or not.
		/// </summary>
		public bool IsAvailable
		{
			get
			{
				return _isAvailable;
			}
		}
	}
}
